@extends('layouts.backend')
@section('mainContent')
      <main>
        <div class="container-fluid">

          <!-- Breadcrumbs-->
          <ol class="breadcrumb">

            <li class="breadcrumb-item active">Edit Notice</li>
          </ol>


          <!-- DataTables Example -->
          <div class="card mb-3">
            <div class="card-header">
              <i class="fas fa-table"></i> Edit Notice
              <a href="{{route('ShowStudentNotice')}}" class="float-right btn btn-sm btn-dark">All Notice</a>
            </div>
            <div class="card-body">
              <div class="table-responsive">

                @if($errors)
                  @foreach($errors->all() as $error)
                    <p class="text-danger">{{$error}}</p>
                  @endforeach
                @endif

                @if(Session::has('success'))
                <p class="text-success">{{session('success')}}</p>
                @endif

                <form method="post" action="{{route('UpdateStudentNotice', $studentnotice->id)}}" enctype="multipart/form-data">
                  @csrf
                  @method('PUT')
                  <table class="table table-bordered">
                    <tr>
                        <th>Title<span class="text-danger">*</span></th>
                        <td>
                          <input type="text" class="form-control" name="title" value="{{$studentnotice->title}}">
                        </td>
                    </tr>
                    <tr>
                        <th>Date<span class="text-danger">*</span></th>
                        <td>
                          <input type="date" class="form-control" name="date" value="{{$studentnotice->date}}">
                        </td>
                    </tr>
                      <tr>
                          <th>Notice<span class="text-danger">*</span></th>
                          <td>
                            <textarea class="form-control" cols="30" rows="15" name="notice">{{$studentnotice->notice}}</textarea>
                          </td>
                      </tr>
                      <tr>
                          <td colspan="2">
                              <input type="submit" class="btn btn-dark" value="Edit Notice"/>
                          </td>
                      </tr>
                  </table>
                </form>
              </div>
            </div>
          </div>

        </div>
      </main>
        <!-- /.container-fluid -->
@endsection

